<?php if(isset($pageConfigs)): ?>
    <?php echo Helper::updatePageConfig($pageConfigs); ?>

<?php endif; ?>

<!DOCTYPE html>

<?php
$configData = Helper::applClasses();
$get_auth_config = Helper::getAuthConfig();
?>

<html lang="<?php if(session()->has('locale')): ?> <?php echo e(session()->get('locale')); ?><?php else: ?><?php echo e($configData['defaultLanguage']); ?> <?php endif; ?>"
    data-textdirection="<?php echo e(env('MIX_CONTENT_DIRECTION') === 'rtl' ? 'rtl' : 'ltr'); ?>"
    class="<?php echo e($configData['theme'] === 'light' ? '' : $configData['layoutTheme']); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?> - Promolider</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/logo/favicon_navidad (1).ico')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600"
        rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('css/openpay.css')); ?>">
    
    <?php echo $__env->make('panels/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</head>
<body>
    <?php echo $__env->yieldContent('content'); ?>

    <!-- seccion para los scrips -->
    <script src="<?php echo e(asset(mix('js/app.js'))); ?>"></script>
    <?php echo $__env->yieldContent('page-script'); ?>
</body>
<script type="text/script">
    window.Laravel = {
        csrfToken: "<?php echo e(csrf_token()); ?>",
        jsPermissions: <?php echo auth()->check()
    ? auth()->user()->jsPermissions()
    : null; ?>

    }
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script><?php /**PATH /home/promolider/public_html/crm.promolider.info/resources/views/layouts/registerLayout.blade.php ENDPATH**/ ?>