<?php // Code within app\Helpers\Helper.php

namespace App\Helpers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\MasterClassNotification;
use App\Models\User;

class CreateNotification
{
    public static function saveNotification(Request $request)
    {
        $rootUser = User::first(); # admin user
        $notification = new MasterClassNotification();
        $notification->transmitter = $request->transmitter ??  $rootUser->id; # If transmitter is not set, then the transmitter will be the admin user
        $notification->receiver = $request->receiver;
        $notification->title = $request->title;
        if ($request->has('body')) {
            $notification->body = $request->body;
        }
        if ($request->has('url')) {
            $notification->url = $request->url;
        }
        if ($request->has('icon')) {
            $notification->icon = $request->icon;
        }
        $notification->save();
        if ($notification->save()) {
            return true;
        }
        return false;
    }
}
